/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.List;
import main.Display;
import main.Header;
import main.NetworkOptions;
import main.NetworkResponse;

public class Network {
    public static NetworkResponse internalPostBytes(NetworkOptions options, List<Header> headers, byte[] body) throws SocketTimeoutException, IOException, ConnectException, IllegalArgumentException {
        HttpURLConnection connection = null;
        URL url = null;
        try {
            url = new URL(options.url);
        }
        catch (MalformedURLException e) {
            Display.responseJTA.setText(e.getMessage());
            return null;
        }
        if (url.getPort() > 65535) {
            Display.responseJTA.setText("Invalid port.");
            return null;
        }
        long start = System.currentTimeMillis();
        connection = (HttpURLConnection)url.openConnection();
        int i = 0;
        while (i < headers.size()) {
            Header h = headers.get(i);
            if (h.enabled.isSelected()) {
                connection.addRequestProperty(h.name.getText(), h.value.getText());
                System.out.println("Adding header " + h.name.getText() + ": " + h.value.getText());
            }
            ++i;
        }
        connection.setRequestMethod(options.request_type);
        connection.setUseCaches(false);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setConnectTimeout(20000);
        connection.setReadTimeout(20000);
        if ((options.request_type.equalsIgnoreCase("POST") || options.request_type.equalsIgnoreCase("PUT")) && body != null) {
            if (body.length >= 1) {
                DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
                wr.write(body);
                wr.flush();
                wr.close();
            } else {
                DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
                wr.write(0);
                wr.flush();
                wr.close();
            }
        }
        InputStream is = null;
        is = connection.getResponseCode() >= 300 ? connection.getErrorStream() : connection.getInputStream();
        if (is == null) {
            Display.responseJTA.setText("Failed to read from server. (http/https?)");
            connection.disconnect();
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int BUFFER_SIZE = 4096;
        int code = connection.getResponseCode();
        String message = connection.getResponseMessage();
        int bytesRead = -1;
        byte[] buffer = new byte[BUFFER_SIZE];
        while ((bytesRead = is.read(buffer)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        is.close();
        baos.close();
        connection.disconnect();
        long end = System.currentTimeMillis();
        return new NetworkResponse(baos.toByteArray(), code, message, end - start);
    }
}

