/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import main.ComponentGenerator;
import main.Header;
import main.Network;
import main.NetworkOptions;
import main.NetworkResponse;

public class Display {
    private static NetworkResponse previous_response = null;
    public static JTextArea responseJTA = null;
    private static JScrollPane responseJSP = null;
    private static JLabel responseImage = null;
    private static int JTA_Width = 665;
    private static int JTA_Height = 200;
    private static int SEPERATOR_Y = 300;
    private static int MAX_DISPLAY_LENGTH = 100000;
    private static int MAX_DISPLAY_LENGTH_TEXT = 5000000;
    private static Color loadingColor = new Color(40, 40, 40);
    private static Color unselectedPaneColor = new Color(120, 120, 120);
    private static int DISPLAY_TEXT = 0;
    private static int DISPLAY_BIN = 1;
    private static int DISPLAY_IMAGE = 2;
    public static Header nextHeader = null;
    public static JPanel contentPane = null;
    public static List<Header> headers = new ArrayList<Header>();

    private static void displayData(int display_type) {
        responseJSP.setVisible(true);
        responseImage.setVisible(false);
        if (display_type == DISPLAY_TEXT) {
            responseJTA.setForeground(loadingColor);
            responseJTA.setText("Loading...");
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    responseJTA.setForeground(Color.BLACK);
                    String set = previous_response.responseString;
                    if (set.length() > MAX_DISPLAY_LENGTH_TEXT) {
                        set = set.substring(0, MAX_DISPLAY_LENGTH_TEXT);
                    }
                    responseJTA.setText(set);
                    responseJTA.setCaretPosition(0);
                }
            });
        } else if (display_type == DISPLAY_BIN) {
            final StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < Math.min(Display.previous_response.response.length, MAX_DISPLAY_LENGTH)) {
                sb.append(String.format("%02X", Display.previous_response.response[i]));
                if (i < Display.previous_response.response.length - 1) {
                    sb.append(" ");
                }
                ++i;
            }
            responseJTA.setForeground(loadingColor);
            responseJTA.setText("Loading...");
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    responseJTA.setForeground(Color.BLACK);
                    responseJTA.setText(sb.toString());
                    responseJTA.setCaretPosition(0);
                }
            });
        } else if (display_type == DISPLAY_IMAGE) {
            try {
                BufferedImage img;
                ByteArrayInputStream bis = new ByteArrayInputStream(Display.previous_response.response);
                Image scaled = img = ImageIO.read(bis);
                if (img.getWidth() > JTA_Width || img.getHeight() > JTA_Height) {
                    float percX = (float)img.getWidth() / (float)JTA_Width;
                    float percY = (float)img.getHeight() / (float)JTA_Height;
                    float scaleDown = Math.max(percX, percY);
                    int newX = Math.max((int)((float)img.getWidth() / scaleDown), 1);
                    int newY = Math.max((int)((float)img.getHeight() / scaleDown), 1);
                    scaled = img.getScaledInstance(newX, newY, 4);
                }
                responseJSP.setVisible(false);
                responseImage.setVisible(true);
                ImageIcon icon = new ImageIcon(scaled);
                int stX = (JTA_Width - icon.getIconWidth()) / 2;
                int stY = (JTA_Height - icon.getIconHeight()) / 2;
                responseImage.setIcon(icon);
                responseImage.setBounds(stX, stY + SEPERATOR_Y + 40, icon.getIconWidth(), icon.getIconHeight());
            }
            catch (Exception e) {
                responseJSP.setVisible(true);
                responseImage.setVisible(false);
                responseJTA.setText("Can't display as image.");
            }
        }
    }

    public static void initWindow() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JFrame fr = new JFrame();
        contentPane = new JPanel();
        fr.setTitle("Lightweight HTTP Client 1.0");
        fr.setVisible(true);
        fr.setResizable(false);
        fr.setDefaultCloseOperation(3);
        fr.setContentPane(contentPane);
        fr.setLayout(null);
        contentPane.setBackground(new Color(40, 40, 40));
        Font boldTextFont = new Font("Tahoma", 1, 12);
        Font textFont = new Font("Tahoma", 0, 12);
        Font smallFont = new Font("Tahoma", 0, 10);
        JLabel label1 = ComponentGenerator.createJLabel("Request:", Color.WHITE, boldTextFont, 10, 20, 67, 20);
        final JComboBox<String> jcb = new JComboBox<String>();
        jcb.setBackground(new Color(70, 70, 70));
        jcb.setLocation(77, 21);
        jcb.setSize(75, 20);
        jcb.setEnabled(true);
        jcb.addItem("GET");
        jcb.addItem("POST");
        jcb.addItem("PUT");
        jcb.addItem("OPTIONS");
        jcb.setFocusable(false);
        final JTextField jtf = ComponentGenerator.createJTextField("Enter request here.", 155, 21, new Color(70, 70, 70), 400, 20, true, "");
        jtf.setForeground(Color.LIGHT_GRAY);
        jtf.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (jtf.getText().equals("Enter request here.")) {
                    jtf.setText("");
                    jtf.setForeground(new Color(160, 210, 255));
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (jtf.getText().isEmpty()) {
                    jtf.setForeground(Color.LIGHT_GRAY);
                    jtf.setText("Enter request here.");
                }
            }
        });
        jtf.setFont(textFont);
        JButton send = new JButton("Send");
        send.setBackground(new Color(70, 70, 70));
        send.setBounds(560, 15, 70, 30);
        send.setVisible(true);
        send.setOpaque(false);
        send.setFocusable(false);
        JLabel headerListLabel = ComponentGenerator.createJLabel("Headers", Color.WHITE, boldTextFont, 10, 60, 60, 20);
        Header userAgentHeader = new Header("User-Agent", "JavaLHC/1.0", 80);
        userAgentHeader.addToJPanel(contentPane);
        Header contentTypeHeader = new Header("Content-Type", "text/plain", 100);
        contentTypeHeader.addToJPanel(contentPane);
        Header acceptHeader = new Header("Accept", "*/*", 120);
        acceptHeader.addToJPanel(contentPane);
        headers.add(userAgentHeader);
        headers.add(contentTypeHeader);
        headers.add(acceptHeader);
        nextHeader = new Header(140);
        nextHeader.addToJPanel(contentPane);
        JLabel requestBodyLabel = ComponentGenerator.createJLabel("Body", Color.WHITE, boldTextFont, 250, 60, 60, 20);
        final JTextArea bodyJTA = new JTextArea();
        bodyJTA.setLineWrap(true);
        bodyJTA.setEditable(false);
        bodyJTA.setForeground(unselectedPaneColor);
        bodyJTA.setText("Enter POST/PUT request body here.");
        JScrollPane bodyJSP = new JScrollPane(bodyJTA);
        bodyJSP.setVerticalScrollBarPolicy(22);
        bodyJSP.setVisible(true);
        bodyJSP.setBounds(250, 80, 325, 200);
        JSeparator js = new JSeparator(0);
        js.setBounds(0, SEPERATOR_Y, 700, 10);
        js.setForeground(new Color(50, 50, 50));
        js.setBackground(new Color(50, 50, 50));
        JLabel responseLabel = ComponentGenerator.createJLabel("Response", Color.WHITE, boldTextFont, 10, SEPERATOR_Y + 10, 60, 20);
        final JLabel responseTypeLabel = ComponentGenerator.createJLabel("Status:", Color.WHITE, textFont, 460, SEPERATOR_Y + 10, 60, 20);
        final JLabel responseTypeLabel2 = ComponentGenerator.createJLabel("200 OK", Color.WHITE, boldTextFont, 505, SEPERATOR_Y + 10, 150, 20);
        responseTypeLabel.setVisible(false);
        responseTypeLabel2.setVisible(false);
        JLabel displayTypeLabel = ComponentGenerator.createJLabel("Display:", Color.WHITE, textFont, 250, SEPERATOR_Y + 10, 50, 20);
        final JComboBox<String> displayTypeDropdown = new JComboBox<String>();
        displayTypeDropdown.setBackground(new Color(70, 70, 70));
        displayTypeDropdown.setLocation(300, SEPERATOR_Y + 11);
        displayTypeDropdown.setSize(60, 20);
        displayTypeDropdown.setEnabled(true);
        displayTypeDropdown.addItem("Text");
        displayTypeDropdown.addItem("Binary");
        displayTypeDropdown.addItem("Image");
        displayTypeDropdown.setFocusable(false);
        responseJTA = new JTextArea();
        responseJTA.setLineWrap(true);
        responseJTA.setEditable(false);
        responseJSP = new JScrollPane(responseJTA);
        responseJSP.setVerticalScrollBarPolicy(22);
        responseJSP.setVisible(true);
        responseJSP.setBounds(10, SEPERATOR_Y + 40, 665, 200);
        responseImage = new JLabel();
        responseImage.setVisible(true);
        responseImage.setBounds(0, 0, 0, 0);
        final JLabel bytes_read = ComponentGenerator.createJLabel("Size: ", Color.WHITE, smallFont, 10, 540, 300, 20);
        final JLabel time_taken = ComponentGenerator.createJLabel("Time taken: ", Color.WHITE, smallFont, 410, 540, 300, 20);
        contentPane.add(label1);
        contentPane.add(jcb);
        contentPane.add(jtf);
        contentPane.add(send);
        contentPane.add(js);
        contentPane.add(responseLabel);
        contentPane.add(responseTypeLabel);
        contentPane.add(responseTypeLabel2);
        contentPane.add(responseJSP);
        contentPane.add(bytes_read);
        contentPane.add(time_taken);
        contentPane.add(displayTypeDropdown);
        contentPane.add(displayTypeLabel);
        contentPane.add(responseImage);
        contentPane.add(headerListLabel);
        contentPane.add(requestBodyLabel);
        contentPane.add(bodyJSP);
        send.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    NetworkResponse res;
                    String body = bodyJTA.getText();
                    if (body.equals("Enter POST/PUT request body here.")) {
                        body = "";
                    }
                    if ((res = Network.internalPostBytes(new NetworkOptions("" + jcb.getSelectedItem(), jtf.getText()), headers, body.getBytes())) == null) {
                        return;
                    }
                    previous_response = res;
                    responseTypeLabel2.setText(res.http_message);
                    responseTypeLabel.setVisible(true);
                    responseTypeLabel2.setVisible(true);
                    bytes_read.setText("Size: " + String.format("%,d", res.response.length) + " bytes.");
                    time_taken.setText("Time taken: " + String.format("%,d", res.read_time) + "ms");
                    int display = displayTypeDropdown.getSelectedIndex();
                    Display.displayData(display);
                }
                catch (SocketTimeoutException ex) {
                    responseJTA.setText("Socket timed out.");
                }
                catch (ConnectException ex) {
                    responseJTA.setText("Could not connect to server.");
                }
                catch (SocketException ex) {
                    responseJTA.setText(ex.getMessage());
                }
                catch (IOException ex) {
                    responseJTA.setText(ex.getMessage());
                }
            }
        });
        displayTypeDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (previous_response == null) {
                    return;
                }
                int display = displayTypeDropdown.getSelectedIndex();
                Display.displayData(display);
            }
        });
        jcb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = jcb.getSelectedIndex();
                if (index == 1 || index == 2) {
                    bodyJTA.setEditable(true);
                    if (!bodyJTA.getText().equals("Enter POST/PUT request body here.")) {
                        bodyJTA.setForeground(Color.BLACK);
                    }
                } else {
                    bodyJTA.setEditable(false);
                    bodyJTA.setForeground(unselectedPaneColor);
                }
            }
        });
        bodyJTA.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (bodyJTA.getText().equals("")) {
                    bodyJTA.setText("Enter POST/PUT request body here.");
                }
                bodyJTA.setForeground(unselectedPaneColor);
            }

            @Override
            public void focusGained(FocusEvent e) {
                int index = jcb.getSelectedIndex();
                if (index == 1 || index == 2) {
                    if (bodyJTA.getText().equals("Enter POST/PUT request body here.")) {
                        bodyJTA.setText("");
                    }
                    bodyJTA.setForeground(Color.BLACK);
                } else {
                    contentPane.requestFocus();
                }
            }
        });
        fr.setSize(700, 600);
        fr.setLocationRelativeTo(null);
    }
}

